// Code generated by the Encore 1.51.6 client generator. DO NOT EDIT.

// Disable eslint, jshint, and jslint for this file.
/* eslint-disable */
/* jshint ignore:start */
/*jslint-disable*/
import type { CookieWithOptions } from "encore.dev/api";

/**
 * BaseURL is the base URL for calling the Encore application's API.
 */
export type BaseURL = string

export const Local: BaseURL = "http://localhost:4000"

/**
 * Environment returns a BaseURL for calling the cloud environment with the given name.
 */
export function Environment(name: string): BaseURL {
    return `https://${name}-.encr.app`
}

/**
 * PreviewEnv returns a BaseURL for calling the preview environment with the given PR number.
 */
export function PreviewEnv(pr: number | string): BaseURL {
    return Environment(`pr${pr}`)
}

const BROWSER = typeof globalThis === "object" && ("window" in globalThis);

/**
 * Client is an API client for the  Encore application.
 */
export class Client {
    public readonly alumni: alumni.ServiceClient
    public readonly auth: auth.ServiceClient
    public readonly guru: guru.ServiceClient
    public readonly karyawan: karyawan.ServiceClient
    public readonly madrasah: madrasah.ServiceClient
    public readonly reports: reports.ServiceClient
    public readonly siswa: siswa.ServiceClient
    private readonly options: ClientOptions
    private readonly target: string


    /**
     * Creates a Client for calling the public and authenticated APIs of your Encore application.
     *
     * @param target  The target which the client should be configured to use. See Local and Environment for options.
     * @param options Options for the client
     */
    constructor(target: BaseURL, options?: ClientOptions) {
        this.target = target
        this.options = options ?? {}
        const base = new BaseClient(this.target, this.options)
        this.alumni = new alumni.ServiceClient(base)
        this.auth = new auth.ServiceClient(base)
        this.guru = new guru.ServiceClient(base)
        this.karyawan = new karyawan.ServiceClient(base)
        this.madrasah = new madrasah.ServiceClient(base)
        this.reports = new reports.ServiceClient(base)
        this.siswa = new siswa.ServiceClient(base)
    }

    /**
     * Creates a new Encore client with the given client options set.
     *
     * @param options Client options to set. They are merged with existing options.
     **/
    public with(options: ClientOptions): Client {
        return new Client(this.target, {
            ...this.options,
            ...options,
        })
    }
}

/**
 * ClientOptions allows you to override any default behaviour within the generated Encore client.
 */
export interface ClientOptions {
    /**
     * By default the client will use the inbuilt fetch function for making the API requests.
     * however you can override it with your own implementation here if you want to run custom
     * code on each API request made or response received.
     */
    fetcher?: Fetcher

    /** Default RequestInit to be used for the client */
    requestInit?: Omit<RequestInit, "headers"> & { headers?: Record<string, string> }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { createAlumni as api_alumni_create_alumni_createAlumni } from "~backend/alumni/create_alumni";
import { importAlumni as api_alumni_import_alumni_importAlumni } from "~backend/alumni/import_alumni";
import { listAlumni as api_alumni_list_alumni_listAlumni } from "~backend/alumni/list_alumni";

export namespace alumni {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.createAlumni = this.createAlumni.bind(this)
            this.importAlumni = this.importAlumni.bind(this)
            this.listAlumni = this.listAlumni.bind(this)
        }

        /**
         * Creates a new alumni
         */
        public async createAlumni(params: RequestType<typeof api_alumni_create_alumni_createAlumni>): Promise<ResponseType<typeof api_alumni_create_alumni_createAlumni>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/alumni`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_alumni_create_alumni_createAlumni>
        }

        /**
         * Imports multiple alumni records
         */
        public async importAlumni(params: RequestType<typeof api_alumni_import_alumni_importAlumni>): Promise<ResponseType<typeof api_alumni_import_alumni_importAlumni>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/alumni/import`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_alumni_import_alumni_importAlumni>
        }

        /**
         * Lists alumni by madrasah
         */
        public async listAlumni(params: RequestType<typeof api_alumni_list_alumni_listAlumni>): Promise<ResponseType<typeof api_alumni_list_alumni_listAlumni>> {
            // Convert our params into the objects we need for the request
            const query = makeRecord<string, string | string[]>({
                limit:         params.limit === undefined ? undefined : String(params.limit),
                "madrasah_id": params["madrasah_id"],
                offset:        params.offset === undefined ? undefined : String(params.offset),
                search:        params.search,
                "tahun_lulus": params["tahun_lulus"] === undefined ? undefined : String(params["tahun_lulus"]),
            })

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/alumni`, {query, method: "GET", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_alumni_list_alumni_listAlumni>
        }
    }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { login as api_auth_auth_login } from "~backend/auth/auth";
import { registerOperator as api_auth_register_operator_registerOperator } from "~backend/auth/register_operator";

export namespace auth {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.login = this.login.bind(this)
            this.registerOperator = this.registerOperator.bind(this)
        }

        /**
         * Login endpoint for madrasah and superadmin
         */
        public async login(params: RequestType<typeof api_auth_auth_login>): Promise<ResponseType<typeof api_auth_auth_login>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/auth/login`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_auth_auth_login>
        }

        public async registerOperator(params: RequestType<typeof api_auth_register_operator_registerOperator>): Promise<ResponseType<typeof api_auth_register_operator_registerOperator>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/auth/register-operator`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_auth_register_operator_registerOperator>
        }
    }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { createGuru as api_guru_create_guru_createGuru } from "~backend/guru/create_guru";
import { importGuru as api_guru_import_guru_importGuru } from "~backend/guru/import_guru";
import { listGuru as api_guru_list_guru_listGuru } from "~backend/guru/list_guru";

export namespace guru {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.createGuru = this.createGuru.bind(this)
            this.importGuru = this.importGuru.bind(this)
            this.listGuru = this.listGuru.bind(this)
        }

        /**
         * Creates a new guru
         */
        public async createGuru(params: RequestType<typeof api_guru_create_guru_createGuru>): Promise<ResponseType<typeof api_guru_create_guru_createGuru>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/guru`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_guru_create_guru_createGuru>
        }

        /**
         * Imports multiple guru records
         */
        public async importGuru(params: RequestType<typeof api_guru_import_guru_importGuru>): Promise<ResponseType<typeof api_guru_import_guru_importGuru>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/guru/import`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_guru_import_guru_importGuru>
        }

        /**
         * Lists guru by madrasah
         */
        public async listGuru(params: RequestType<typeof api_guru_list_guru_listGuru>): Promise<ResponseType<typeof api_guru_list_guru_listGuru>> {
            // Convert our params into the objects we need for the request
            const query = makeRecord<string, string | string[]>({
                limit:         params.limit === undefined ? undefined : String(params.limit),
                "madrasah_id": params["madrasah_id"],
                offset:        params.offset === undefined ? undefined : String(params.offset),
                search:        params.search,
            })

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/guru`, {query, method: "GET", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_guru_list_guru_listGuru>
        }
    }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { createKaryawan as api_karyawan_create_karyawan_createKaryawan } from "~backend/karyawan/create_karyawan";
import { importKaryawan as api_karyawan_import_karyawan_importKaryawan } from "~backend/karyawan/import_karyawan";
import { listKaryawan as api_karyawan_list_karyawan_listKaryawan } from "~backend/karyawan/list_karyawan";

export namespace karyawan {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.createKaryawan = this.createKaryawan.bind(this)
            this.importKaryawan = this.importKaryawan.bind(this)
            this.listKaryawan = this.listKaryawan.bind(this)
        }

        /**
         * Creates a new karyawan
         */
        public async createKaryawan(params: RequestType<typeof api_karyawan_create_karyawan_createKaryawan>): Promise<ResponseType<typeof api_karyawan_create_karyawan_createKaryawan>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/karyawan`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_karyawan_create_karyawan_createKaryawan>
        }

        /**
         * Imports multiple karyawan records
         */
        public async importKaryawan(params: RequestType<typeof api_karyawan_import_karyawan_importKaryawan>): Promise<ResponseType<typeof api_karyawan_import_karyawan_importKaryawan>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/karyawan/import`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_karyawan_import_karyawan_importKaryawan>
        }

        /**
         * Lists karyawan by madrasah
         */
        public async listKaryawan(params: RequestType<typeof api_karyawan_list_karyawan_listKaryawan>): Promise<ResponseType<typeof api_karyawan_list_karyawan_listKaryawan>> {
            // Convert our params into the objects we need for the request
            const query = makeRecord<string, string | string[]>({
                bagian:        params.bagian,
                limit:         params.limit === undefined ? undefined : String(params.limit),
                "madrasah_id": params["madrasah_id"],
                offset:        params.offset === undefined ? undefined : String(params.offset),
                search:        params.search,
            })

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/karyawan`, {query, method: "GET", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_karyawan_list_karyawan_listKaryawan>
        }
    }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { createMadrasah as api_madrasah_create_madrasah_createMadrasah } from "~backend/madrasah/create_madrasah";
import { deleteMadrasah as api_madrasah_delete_madrasah_deleteMadrasah } from "~backend/madrasah/delete_madrasah";
import { importMadrasah as api_madrasah_import_madrasah_importMadrasah } from "~backend/madrasah/import_madrasah";
import { listMadrasah as api_madrasah_list_madrasah_listMadrasah } from "~backend/madrasah/list_madrasah";
import { resetToken as api_madrasah_reset_token_resetToken } from "~backend/madrasah/reset_token";
import { updateMadrasah as api_madrasah_update_madrasah_updateMadrasah } from "~backend/madrasah/update_madrasah";

export namespace madrasah {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.createMadrasah = this.createMadrasah.bind(this)
            this.deleteMadrasah = this.deleteMadrasah.bind(this)
            this.importMadrasah = this.importMadrasah.bind(this)
            this.listMadrasah = this.listMadrasah.bind(this)
            this.resetToken = this.resetToken.bind(this)
            this.updateMadrasah = this.updateMadrasah.bind(this)
        }

        /**
         * Creates a new madrasah (superadmin only)
         */
        public async createMadrasah(params: RequestType<typeof api_madrasah_create_madrasah_createMadrasah>): Promise<ResponseType<typeof api_madrasah_create_madrasah_createMadrasah>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/madrasah`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_madrasah_create_madrasah_createMadrasah>
        }

        /**
         * Deletes a madrasah (superadmin only)
         */
        public async deleteMadrasah(params: { id: string }): Promise<void> {
            await this.baseClient.callTypedAPI(`/madrasah/${encodeURIComponent(params.id)}`, {method: "DELETE", body: undefined})
        }

        /**
         * Imports multiple madrasah records
         */
        public async importMadrasah(params: RequestType<typeof api_madrasah_import_madrasah_importMadrasah>): Promise<ResponseType<typeof api_madrasah_import_madrasah_importMadrasah>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/madrasah/import`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_madrasah_import_madrasah_importMadrasah>
        }

        /**
         * Lists all madrasah (for superadmin)
         */
        public async listMadrasah(params: RequestType<typeof api_madrasah_list_madrasah_listMadrasah>): Promise<ResponseType<typeof api_madrasah_list_madrasah_listMadrasah>> {
            // Convert our params into the objects we need for the request
            const query = makeRecord<string, string | string[]>({
                limit:  params.limit === undefined ? undefined : String(params.limit),
                offset: params.offset === undefined ? undefined : String(params.offset),
                search: params.search,
            })

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/madrasah`, {query, method: "GET", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_madrasah_list_madrasah_listMadrasah>
        }

        public async resetToken(params: { madrasah_id: string }): Promise<ResponseType<typeof api_madrasah_reset_token_resetToken>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/madrasah/${encodeURIComponent(params.madrasah_id)}/reset-token`, {method: "POST", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_madrasah_reset_token_resetToken>
        }

        /**
         * Updates an existing madrasah (superadmin only)
         */
        public async updateMadrasah(params: RequestType<typeof api_madrasah_update_madrasah_updateMadrasah>): Promise<ResponseType<typeof api_madrasah_update_madrasah_updateMadrasah>> {
            // Construct the body with only the fields which we want encoded within the body (excluding query string or header fields)
            const body: Record<string, any> = {
                akreditasi:      params.akreditasi,
                alamat:          params.alamat,
                kabupaten:       params.kabupaten,
                kecamatan:       params.kecamatan,
                "nama_kepala":   params["nama_kepala"],
                "nama_madrasah": params["nama_madrasah"],
                npsn:            params.npsn,
                nsm:             params.nsm,
                provinsi:        params.provinsi,
                status:          params.status,
            }

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/madrasah/${encodeURIComponent(params.id)}`, {method: "PUT", body: JSON.stringify(body)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_madrasah_update_madrasah_updateMadrasah>
        }
    }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { getRecap as api_reports_recap_getRecap } from "~backend/reports/recap";

export namespace reports {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.getRecap = this.getRecap.bind(this)
        }

        public async getRecap(params: RequestType<typeof api_reports_recap_getRecap>): Promise<ResponseType<typeof api_reports_recap_getRecap>> {
            // Convert our params into the objects we need for the request
            const query = makeRecord<string, string | string[]>({
                "madrasah_id": params["madrasah_id"],
            })

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/reports/recap`, {query, method: "GET", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_reports_recap_getRecap>
        }
    }
}

/**
 * Import the endpoint handlers to derive the types for the client.
 */
import { createSiswa as api_siswa_create_siswa_createSiswa } from "~backend/siswa/create_siswa";
import { importSiswa as api_siswa_import_siswa_importSiswa } from "~backend/siswa/import_siswa";
import { listSiswa as api_siswa_list_siswa_listSiswa } from "~backend/siswa/list_siswa";

export namespace siswa {

    export class ServiceClient {
        private baseClient: BaseClient

        constructor(baseClient: BaseClient) {
            this.baseClient = baseClient
            this.createSiswa = this.createSiswa.bind(this)
            this.importSiswa = this.importSiswa.bind(this)
            this.listSiswa = this.listSiswa.bind(this)
        }

        /**
         * Creates a new siswa
         */
        public async createSiswa(params: RequestType<typeof api_siswa_create_siswa_createSiswa>): Promise<ResponseType<typeof api_siswa_create_siswa_createSiswa>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/siswa`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_siswa_create_siswa_createSiswa>
        }

        /**
         * Imports multiple siswa records
         */
        public async importSiswa(params: RequestType<typeof api_siswa_import_siswa_importSiswa>): Promise<ResponseType<typeof api_siswa_import_siswa_importSiswa>> {
            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/siswa/import`, {method: "POST", body: JSON.stringify(params)})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_siswa_import_siswa_importSiswa>
        }

        /**
         * Lists siswa by madrasah
         */
        public async listSiswa(params: RequestType<typeof api_siswa_list_siswa_listSiswa>): Promise<ResponseType<typeof api_siswa_list_siswa_listSiswa>> {
            // Convert our params into the objects we need for the request
            const query = makeRecord<string, string | string[]>({
                kelas:         params.kelas,
                limit:         params.limit === undefined ? undefined : String(params.limit),
                "madrasah_id": params["madrasah_id"],
                offset:        params.offset === undefined ? undefined : String(params.offset),
                search:        params.search,
                status:        params.status,
            })

            // Now make the actual call to the API
            const resp = await this.baseClient.callTypedAPI(`/siswa`, {query, method: "GET", body: undefined})
            return JSON.parse(await resp.text(), dateReviver) as ResponseType<typeof api_siswa_list_siswa_listSiswa>
        }
    }
}


type PickMethods<Type> = Omit<CallParameters, "method"> & { method?: Type };

// Helper type to omit all fields that are cookies.
type OmitCookie<T> = {
  [K in keyof T as T[K] extends CookieWithOptions<any> ? never : K]: T[K];
};

type RequestType<Type extends (...args: any[]) => any> =
  Parameters<Type> extends [infer H, ...any[]]
    ? OmitCookie<H>
    : void;

type ResponseType<Type extends (...args: any[]) => any> = OmitCookie<Awaited<ReturnType<Type>>>;

function dateReviver(key: string, value: any): any {
  if (
    typeof value === "string" &&
    value.length >= 10 &&
    value.charCodeAt(0) >= 48 && // '0'
    value.charCodeAt(0) <= 57 // '9'
  ) {
    const parsedDate = new Date(value);
    if (!isNaN(parsedDate.getTime())) {
      return parsedDate;
    }
  }
  return value;
}


function encodeQuery(parts: Record<string, string | string[]>): string {
    const pairs: string[] = []
    for (const key in parts) {
        const val = (Array.isArray(parts[key]) ?  parts[key] : [parts[key]]) as string[]
        for (const v of val) {
            pairs.push(`${key}=${encodeURIComponent(v)}`)
        }
    }
    return pairs.join("&")
}

// makeRecord takes a record and strips any undefined values from it,
// and returns the same record with a narrower type.
// @ts-ignore - TS ignore because makeRecord is not always used
function makeRecord<K extends string | number | symbol, V>(record: Record<K, V | undefined>): Record<K, V> {
    for (const key in record) {
        if (record[key] === undefined) {
            delete record[key]
        }
    }
    return record as Record<K, V>
}

import {
  StreamInOutHandlerFn,
  StreamInHandlerFn,
  StreamOutHandlerFn,
} from "encore.dev/api";

type StreamRequest<Type> = Type extends
  | StreamInOutHandlerFn<any, infer Req, any>
  | StreamInHandlerFn<any, infer Req, any>
  | StreamOutHandlerFn<any, any>
  ? Req
  : never;

type StreamResponse<Type> = Type extends
  | StreamInOutHandlerFn<any, any, infer Resp>
  | StreamInHandlerFn<any, any, infer Resp>
  | StreamOutHandlerFn<any, infer Resp>
  ? Resp
  : never;


function encodeWebSocketHeaders(headers: Record<string, string>) {
    // url safe, no pad
    const base64encoded = btoa(JSON.stringify(headers))
      .replaceAll("=", "")
      .replaceAll("+", "-")
      .replaceAll("/", "_");
    return "encore.dev.headers." + base64encoded;
}

class WebSocketConnection {
    public ws: WebSocket;

    private hasUpdateHandlers: (() => void)[] = [];

    constructor(url: string, headers?: Record<string, string>) {
        let protocols = ["encore-ws"];
        if (headers) {
            protocols.push(encodeWebSocketHeaders(headers))
        }

        this.ws = new WebSocket(url, protocols)

        this.on("error", () => {
            this.resolveHasUpdateHandlers();
        });

        this.on("close", () => {
            this.resolveHasUpdateHandlers();
        });
    }

    resolveHasUpdateHandlers() {
        const handlers = this.hasUpdateHandlers;
        this.hasUpdateHandlers = [];

        for (const handler of handlers) {
            handler()
        }
    }

    async hasUpdate() {
        // await until a new message have been received, or the socket is closed
        await new Promise((resolve) => {
            this.hasUpdateHandlers.push(() => resolve(null))
        });
    }

    on(type: "error" | "close" | "message" | "open", handler: (event: any) => void) {
        this.ws.addEventListener(type, handler);
    }

    off(type: "error" | "close" | "message" | "open", handler: (event: any) => void) {
        this.ws.removeEventListener(type, handler);
    }

    close() {
        this.ws.close();
    }
}

export class StreamInOut<Request, Response> {
    public socket: WebSocketConnection;
    private buffer: Response[] = [];

    constructor(url: string, headers?: Record<string, string>) {
        this.socket = new WebSocketConnection(url, headers);
        this.socket.on("message", (event: any) => {
            this.buffer.push(JSON.parse(event.data, dateReviver));
            this.socket.resolveHasUpdateHandlers();
        });
    }

    close() {
        this.socket.close();
    }

    async send(msg: Request) {
        if (this.socket.ws.readyState === WebSocket.CONNECTING) {
            // await that the socket is opened
            await new Promise((resolve) => {
                this.socket.ws.addEventListener("open", resolve, { once: true });
            });
        }

        return this.socket.ws.send(JSON.stringify(msg));
    }

    async next(): Promise<Response | undefined> {
        for await (const next of this) return next;
        return undefined;
    }

    async *[Symbol.asyncIterator](): AsyncGenerator<Response, undefined, void> {
        while (true) {
            if (this.buffer.length > 0) {
                yield this.buffer.shift() as Response;
            } else {
                if (this.socket.ws.readyState === WebSocket.CLOSED) return;
                await this.socket.hasUpdate();
            }
        }
    }
}

export class StreamIn<Response> {
    public socket: WebSocketConnection;
    private buffer: Response[] = [];

    constructor(url: string, headers?: Record<string, string>) {
        this.socket = new WebSocketConnection(url, headers);
        this.socket.on("message", (event: any) => {
            this.buffer.push(JSON.parse(event.data, dateReviver));
            this.socket.resolveHasUpdateHandlers();
        });
    }

    close() {
        this.socket.close();
    }

    async next(): Promise<Response | undefined> {
        for await (const next of this) return next;
        return undefined;
    }

    async *[Symbol.asyncIterator](): AsyncGenerator<Response, undefined, void> {
        while (true) {
            if (this.buffer.length > 0) {
                yield this.buffer.shift() as Response;
            } else {
                if (this.socket.ws.readyState === WebSocket.CLOSED) return;
                await this.socket.hasUpdate();
            }
        }
    }
}

export class StreamOut<Request, Response> {
    public socket: WebSocketConnection;
    private responseValue: Promise<Response>;

    constructor(url: string, headers?: Record<string, string>) {
        let responseResolver: (_: any) => void;
        this.responseValue = new Promise((resolve) => responseResolver = resolve);

        this.socket = new WebSocketConnection(url, headers);
        this.socket.on("message", (event: any) => {
            responseResolver(JSON.parse(event.data, dateReviver))
        });
    }

    async response(): Promise<Response> {
        return this.responseValue;
    }

    close() {
        this.socket.close();
    }

    async send(msg: Request) {
        if (this.socket.ws.readyState === WebSocket.CONNECTING) {
            // await that the socket is opened
            await new Promise((resolve) => {
                this.socket.ws.addEventListener("open", resolve, { once: true });
            });
        }

        return this.socket.ws.send(JSON.stringify(msg));
    }
}
// CallParameters is the type of the parameters to a method call, but require headers to be a Record type
type CallParameters = Omit<RequestInit, "headers"> & {
    /** Headers to be sent with the request */
    headers?: Record<string, string>

    /** Query parameters to be sent with the request */
    query?: Record<string, string | string[]>
}


// A fetcher is the prototype for the inbuilt Fetch function
export type Fetcher = typeof fetch;

const boundFetch = fetch.bind(this);

class BaseClient {
    readonly baseURL: string
    readonly fetcher: Fetcher
    readonly headers: Record<string, string>
    readonly requestInit: Omit<RequestInit, "headers"> & { headers?: Record<string, string> }

    constructor(baseURL: string, options: ClientOptions) {
        this.baseURL = baseURL
        this.headers = {}

        // Add User-Agent header if the script is running in the server
        // because browsers do not allow setting User-Agent headers to requests
        if (!BROWSER) {
            this.headers["User-Agent"] = "-Generated-TS-Client (Encore/1.51.6)";
        }

        this.requestInit = options.requestInit ?? {};

        // Setup what fetch function we'll be using in the base client
        if (options.fetcher !== undefined) {
            this.fetcher = options.fetcher
        } else {
            this.fetcher = boundFetch
        }
    }

    async getAuthData(): Promise<CallParameters | undefined> {
        return undefined;
    }

    // createStreamInOut sets up a stream to a streaming API endpoint.
    async createStreamInOut<Request, Response>(path: string, params?: CallParameters): Promise<StreamInOut<Request, Response>> {
        let { query, headers } = params ?? {};

        // Fetch auth data if there is any
        const authData = await this.getAuthData();

        // If we now have authentication data, add it to the request
        if (authData) {
            if (authData.query) {
                query = {...query, ...authData.query};
            }
            if (authData.headers) {
                headers = {...headers, ...authData.headers};
            }
        }

        const queryString = query ? '?' + encodeQuery(query) : ''
        return new StreamInOut(this.baseURL + path + queryString, headers);
    }

    // createStreamIn sets up a stream to a streaming API endpoint.
    async createStreamIn<Response>(path: string, params?: CallParameters): Promise<StreamIn<Response>> {
        let { query, headers } = params ?? {};

        // Fetch auth data if there is any
        const authData = await this.getAuthData();

        // If we now have authentication data, add it to the request
        if (authData) {
            if (authData.query) {
                query = {...query, ...authData.query};
            }
            if (authData.headers) {
                headers = {...headers, ...authData.headers};
            }
        }

        const queryString = query ? '?' + encodeQuery(query) : ''
        return new StreamIn(this.baseURL + path + queryString, headers);
    }

    // createStreamOut sets up a stream to a streaming API endpoint.
    async createStreamOut<Request, Response>(path: string, params?: CallParameters): Promise<StreamOut<Request, Response>> {
        let { query, headers } = params ?? {};

        // Fetch auth data if there is any
        const authData = await this.getAuthData();

        // If we now have authentication data, add it to the request
        if (authData) {
            if (authData.query) {
                query = {...query, ...authData.query};
            }
            if (authData.headers) {
                headers = {...headers, ...authData.headers};
            }
        }

        const queryString = query ? '?' + encodeQuery(query) : ''
        return new StreamOut(this.baseURL + path + queryString, headers);
    }

    // callTypedAPI makes an API call, defaulting content type to "application/json"
    public async callTypedAPI(path: string, params?: CallParameters): Promise<Response> {
        return this.callAPI(path, {
            ...params,
            headers: { "Content-Type": "application/json", ...params?.headers }
        });
    }

    // callAPI is used by each generated API method to actually make the request
    public async callAPI(path: string, params?: CallParameters): Promise<Response> {
        let { query, headers, ...rest } = params ?? {}
        const init = {
            ...this.requestInit,
            ...rest,
        }

        // Merge our headers with any predefined headers
        init.headers = {...this.headers, ...init.headers, ...headers}

        // Fetch auth data if there is any
        const authData = await this.getAuthData();

        // If we now have authentication data, add it to the request
        if (authData) {
            if (authData.query) {
                query = {...query, ...authData.query};
            }
            if (authData.headers) {
                init.headers = {...init.headers, ...authData.headers};
            }
        }

        // Make the actual request
        const queryString = query ? '?' + encodeQuery(query) : ''
        const response = await this.fetcher(this.baseURL+path+queryString, init)

        // handle any error responses
        if (!response.ok) {
            // try and get the error message from the response body
            let body: APIErrorResponse = { code: ErrCode.Unknown, message: `request failed: status ${response.status}` }

            // if we can get the structured error we should, otherwise give a best effort
            try {
                const text = await response.text()

                try {
                    const jsonBody = JSON.parse(text)
                    if (isAPIErrorResponse(jsonBody)) {
                        body = jsonBody
                    } else {
                        body.message += ": " + JSON.stringify(jsonBody)
                    }
                } catch {
                    body.message += ": " + text
                }
            } catch (e) {
                // otherwise we just append the text to the error message
                body.message += ": " + String(e)
            }

            throw new APIError(response.status, body)
        }

        return response
    }
}

/**
 * APIErrorDetails represents the response from an Encore API in the case of an error
 */
interface APIErrorResponse {
    code: ErrCode
    message: string
    details?: any
}

function isAPIErrorResponse(err: any): err is APIErrorResponse {
    return (
        err !== undefined && err !== null &&
        isErrCode(err.code) &&
        typeof(err.message) === "string" &&
        (err.details === undefined || err.details === null || typeof(err.details) === "object")
    )
}

function isErrCode(code: any): code is ErrCode {
    return code !== undefined && Object.values(ErrCode).includes(code)
}

/**
 * APIError represents a structured error as returned from an Encore application.
 */
export class APIError extends Error {
    /**
     * The HTTP status code associated with the error.
     */
    public readonly status: number

    /**
     * The Encore error code
     */
    public readonly code: ErrCode

    /**
     * The error details
     */
    public readonly details?: any

    constructor(status: number, response: APIErrorResponse) {
        // extending errors causes issues after you construct them, unless you apply the following fixes
        super(response.message);

        // set error name as constructor name, make it not enumerable to keep native Error behavior
        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new.target#new.target_in_constructors
        Object.defineProperty(this, 'name', {
            value:        'APIError',
            enumerable:   false,
            configurable: true,
        })

        // fix the prototype chain
        if ((Object as any).setPrototypeOf == undefined) {
            (this as any).__proto__ = APIError.prototype
        } else {
            Object.setPrototypeOf(this, APIError.prototype);
        }

        // capture a stack trace
        if ((Error as any).captureStackTrace !== undefined) {
            (Error as any).captureStackTrace(this, this.constructor);
        }

        this.status = status
        this.code = response.code
        this.details = response.details
    }
}

/**
 * Typeguard allowing use of an APIError's fields'
 */
export function isAPIError(err: any): err is APIError {
    return err instanceof APIError;
}

export enum ErrCode {
    /**
     * OK indicates the operation was successful.
     */
    OK = "ok",

    /**
     * Canceled indicates the operation was canceled (typically by the caller).
     *
     * Encore will generate this error code when cancellation is requested.
     */
    Canceled = "canceled",

    /**
     * Unknown error. An example of where this error may be returned is
     * if a Status value received from another address space belongs to
     * an error-space that is not known in this address space. Also
     * errors raised by APIs that do not return enough error information
     * may be converted to this error.
     *
     * Encore will generate this error code in the above two mentioned cases.
     */
    Unknown = "unknown",

    /**
     * InvalidArgument indicates client specified an invalid argument.
     * Note that this differs from FailedPrecondition. It indicates arguments
     * that are problematic regardless of the state of the system
     * (e.g., a malformed file name).
     *
     * This error code will not be generated by the gRPC framework.
     */
    InvalidArgument = "invalid_argument",

    /**
     * DeadlineExceeded means operation expired before completion.
     * For operations that change the state of the system, this error may be
     * returned even if the operation has completed successfully. For
     * example, a successful response from a server could have been delayed
     * long enough for the deadline to expire.
     *
     * The gRPC framework will generate this error code when the deadline is
     * exceeded.
     */
    DeadlineExceeded = "deadline_exceeded",

    /**
     * NotFound means some requested entity (e.g., file or directory) was
     * not found.
     *
     * This error code will not be generated by the gRPC framework.
     */
    NotFound = "not_found",

    /**
     * AlreadyExists means an attempt to create an entity failed because one
     * already exists.
     *
     * This error code will not be generated by the gRPC framework.
     */
    AlreadyExists = "already_exists",

    /**
     * PermissionDenied indicates the caller does not have permission to
     * execute the specified operation. It must not be used for rejections
     * caused by exhausting some resource (use ResourceExhausted
     * instead for those errors). It must not be
     * used if the caller cannot be identified (use Unauthenticated
     * instead for those errors).
     *
     * This error code will not be generated by the gRPC core framework,
     * but expect authentication middleware to use it.
     */
    PermissionDenied = "permission_denied",

    /**
     * ResourceExhausted indicates some resource has been exhausted, perhaps
     * a per-user quota, or perhaps the entire file system is out of space.
     *
     * This error code will be generated by the gRPC framework in
     * out-of-memory and server overload situations, or when a message is
     * larger than the configured maximum size.
     */
    ResourceExhausted = "resource_exhausted",

    /**
     * FailedPrecondition indicates operation was rejected because the
     * system is not in a state required for the operation's execution.
     * For example, directory to be deleted may be non-empty, an rmdir
     * operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FailedPrecondition, Aborted, and Unavailable:
     *  (a) Use Unavailable if the client can retry just the failing call.
     *  (b) Use Aborted if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FailedPrecondition if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FailedPrecondition
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FailedPrecondition if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     *
     * This error code will not be generated by the gRPC framework.
     */
    FailedPrecondition = "failed_precondition",

    /**
     * Aborted indicates the operation was aborted, typically due to a
     * concurrency issue like sequencer check failures, transaction aborts,
     * etc.
     *
     * See litmus test above for deciding between FailedPrecondition,
     * Aborted, and Unavailable.
     */
    Aborted = "aborted",

    /**
     * OutOfRange means operation was attempted past the valid range.
     * E.g., seeking or reading past end of file.
     *
     * Unlike InvalidArgument, this error indicates a problem that may
     * be fixed if the system state changes. For example, a 32-bit file
     * system will generate InvalidArgument if asked to read at an
     * offset that is not in the range [0,2^32-1], but it will generate
     * OutOfRange if asked to read from an offset past the current
     * file size.
     *
     * There is a fair bit of overlap between FailedPrecondition and
     * OutOfRange. We recommend using OutOfRange (the more specific
     * error) when it applies so that callers who are iterating through
     * a space can easily look for an OutOfRange error to detect when
     * they are done.
     *
     * This error code will not be generated by the gRPC framework.
     */
    OutOfRange = "out_of_range",

    /**
     * Unimplemented indicates operation is not implemented or not
     * supported/enabled in this service.
     *
     * This error code will be generated by the gRPC framework. Most
     * commonly, you will see this error code when a method implementation
     * is missing on the server. It can also be generated for unknown
     * compression algorithms or a disagreement as to whether an RPC should
     * be streaming.
     */
    Unimplemented = "unimplemented",

    /**
     * Internal errors. Means some invariants expected by underlying
     * system has been broken. If you see one of these errors,
     * something is very broken.
     *
     * This error code will be generated by the gRPC framework in several
     * internal error conditions.
     */
    Internal = "internal",

    /**
     * Unavailable indicates the service is currently unavailable.
     * This is a most likely a transient condition and may be corrected
     * by retrying with a backoff. Note that it is not always safe to retry
     * non-idempotent operations.
     *
     * See litmus test above for deciding between FailedPrecondition,
     * Aborted, and Unavailable.
     *
     * This error code will be generated by the gRPC framework during
     * abrupt shutdown of a server process or network connection.
     */
    Unavailable = "unavailable",

    /**
     * DataLoss indicates unrecoverable data loss or corruption.
     *
     * This error code will not be generated by the gRPC framework.
     */
    DataLoss = "data_loss",

    /**
     * Unauthenticated indicates the request does not have valid
     * authentication credentials for the operation.
     *
     * The gRPC framework will generate this error code when the
     * authentication metadata is invalid or a Credentials callback fails,
     * but also expect authentication middleware to generate it.
     */
    Unauthenticated = "unauthenticated",
}

export default new Client(import.meta.env.VITE_CLIENT_TARGET, { requestInit: { credentials: "include" } });
