-- Create madrasah table
CREATE TABLE madrasah (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  nsm VARCHAR(20) UNIQUE NOT NULL,
  npsn VARCHAR(20) NOT NULL,
  nama_madrasah VARCHAR(255) NOT NULL,
  alamat TEXT,
  kecamatan VARCHAR(100),
  kabupaten VARCHAR(100),
  provinsi VARCHAR(100),
  akreditasi VARCHAR(10),
  status VARCHAR(50),
  nama_kepala VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create guru table
CREATE TABLE guru (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  madrasah_id UUID REFERENCES madrasah(id) ON DELETE CASCADE,
  nip VARCHAR(30),
  nama_lengkap VARCHAR(255) NOT NULL,
  tempat_lahir VARCHAR(100),
  tanggal_lahir DATE,
  jenis_kelamin VARCHAR(10),
  agama VARCHAR(20),
  alamat TEXT,
  no_telepon VARCHAR(20),
  email VARCHAR(100),
  pendidikan_terakhir VARCHAR(50),
  mata_pelajaran VARCHAR(100),
  status_kepegawaian VARCHAR(50),
  tanggal_masuk DATE,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create siswa table
CREATE TABLE siswa (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  madrasah_id UUID REFERENCES madrasah(id) ON DELETE CASCADE,
  nisn VARCHAR(20),
  nis VARCHAR(20),
  nama_lengkap VARCHAR(255) NOT NULL,
  tempat_lahir VARCHAR(100),
  tanggal_lahir DATE,
  jenis_kelamin VARCHAR(10),
  agama VARCHAR(20),
  alamat TEXT,
  no_telepon VARCHAR(20),
  nama_ayah VARCHAR(255),
  nama_ibu VARCHAR(255),
  pekerjaan_ayah VARCHAR(100),
  pekerjaan_ibu VARCHAR(100),
  kelas VARCHAR(10),
  tahun_masuk INTEGER,
  status VARCHAR(20) DEFAULT 'aktif',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create karyawan table
CREATE TABLE karyawan (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  madrasah_id UUID REFERENCES madrasah(id) ON DELETE CASCADE,
  nip VARCHAR(30),
  nama_lengkap VARCHAR(255) NOT NULL,
  tempat_lahir VARCHAR(100),
  tanggal_lahir DATE,
  jenis_kelamin VARCHAR(10),
  agama VARCHAR(20),
  alamat TEXT,
  no_telepon VARCHAR(20),
  email VARCHAR(100),
  pendidikan_terakhir VARCHAR(50),
  jabatan VARCHAR(100),
  bagian VARCHAR(100),
  tanggal_masuk DATE,
  status_kepegawaian VARCHAR(50),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create alumni table
CREATE TABLE alumni (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  madrasah_id UUID REFERENCES madrasah(id) ON DELETE CASCADE,
  nisn VARCHAR(20),
  nis VARCHAR(20),
  nama_lengkap VARCHAR(255) NOT NULL,
  tempat_lahir VARCHAR(100),
  tanggal_lahir DATE,
  jenis_kelamin VARCHAR(10),
  agama VARCHAR(20),
  alamat TEXT,
  no_telepon VARCHAR(20),
  tahun_lulus INTEGER,
  melanjutkan_ke VARCHAR(255),
  pekerjaan VARCHAR(100),
  alamat_sekarang TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert sample madrasah data
INSERT INTO madrasah (nsm, npsn, nama_madrasah, alamat, kecamatan, kabupaten, provinsi, akreditasi, status, nama_kepala) VALUES
('121233020005', '60728474', 'MTS Ma''arif NU 1 Rawalo', 'Jl. Raya Rawalo No. 123', 'Rawalo', 'Banyumas', 'Jawa Tengah', 'A', 'Negeri', 'Drs. Ahmad Fauzi'),
('121233020004', '60728475', 'MTS Ma''arif NU 1 Jatilawang', 'Jl. Pendidikan No. 45', 'Jatilawang', 'Banyumas', 'Jawa Tengah', 'A', 'Swasta', 'Hj. Siti Aminah, S.Pd'),
('121233020003', '60728476', 'MTS Muhammadiyah Wangon', 'Jl. Ahmad Yani No. 67', 'Wangon', 'Banyumas', 'Jawa Tengah', 'B', 'Swasta', 'Drs. Muhammad Ridwan'),
('121233020002', '60728477', 'MTS Ma''arif NU 1 Wangon', 'Jl. Diponegoro No. 89', 'Wangon', 'Banyumas', 'Jawa Tengah', 'A', 'Swasta', 'Ahmad Syukur, S.Ag'),
('121233020001', '60728478', 'MTS Ma''arif NU 1 Lumbir', 'Jl. Sudirman No. 12', 'Lumbir', 'Banyumas', 'Jawa Tengah', 'B', 'Swasta', 'Dra. Fatimah');
